#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "compiler.h"
#include "capi.h"
#include "9188e.h"

static int GetClientSock(void);
int StartListen(int iPort);
char *Err(unsigned uErrCode);
void Aprintf (char *pFormat, ...);
static char *WriteName(NET_ADDR *psAddr);

#define CHAT_PORT 10000
#define BUF_SIZE 200
#define NAME_LEN	20	//my name

static char rgcKeyBuf[BUF_SIZE];//for editing
static int iKeyCount = 0; //number of characters in keybuf
static NET_ADDR sNetAddr; //general use

/*
Sits in a loop and check for two things:
1. If any data was received from the network
	If data was received, it is displayed on screen
2. If the user has entered any data
	If the character entered was a newline, the previously entered data is
	send, else the character is stored in a buffer.
*/
void main(void)
{
	char rgcMyNameBuf[NAME_LEN];//buffer containing my (arbritary) name
	char *pMyName;		//pointer to it
	int iMaxInput;		//maximum no of bytes before we must send (to keep all in buffer)
	char rgcBuf[BUF_SIZE];//general buffer, used for sending and receiving
	int iRcvSock;		//socket for receiving packets
	int iSendSock;		//socket for sending packets
	int iLength;		//Length of string read or written
	char cCh;         //Character read
	char cMoreInfo;	//Whether or not to display additional information
	unsigned int count=0;
    int key1,key2=0;
	
	printf("Sockets UDP Chat client\n");
	printf("Copyright (C) 1999 Datalight, Inc.\nAll Rights Reserved\n\n");

	//get user name and set variables accordingly
	printf("Enter your name (send with all your messages):");
	rgcMyNameBuf[0] = NAME_LEN - 2;
	scanf("%s",rgcMyNameBuf);
	pMyName=rgcMyNameBuf;

	iMaxInput = BUF_SIZE - rgcMyNameBuf[1] - 10;

	//get more info option
	printf("Do you want to see the ip addresses of senders? [Y/N]");
	cCh=getch();
	cMoreInfo = ((cCh=='Y' || cCh=='y') ? 1 : 0);
	
	printf("\nCTRL-T to talk, CTRL-X to exit.\n");

	//start to listen for datagrams
	iRcvSock = StartListen(CHAT_PORT);
	iSendSock = GetClientSock();
	if (iRcvSock == 0 || iSendSock == 0)
		return;
	//tell the world im on the air
	iLength = sprintf(rgcBuf, "%s came on the air", pMyName);
	if (WriteSocket(iSendSock, rgcBuf, iLength, NET_FLG_BROADCAST) < 0)//error
		printf("Error on Sending %d bytes: %s\n",iLength, Err(iNetErrNo));

	while (1)
	{
		//server part - see if we received data
		
		iLength = ReadSocket(iRcvSock, rgcBuf, BUF_SIZE, &sNetAddr, 0);
		if (iNetErrNo != 0 && iNetErrNo != ERR_WOULD_BLOCK)
			printf("Error on Netread: %s\n", Err(iNetErrNo));
		if (iLength > 0)
		{
			rgcBuf[iLength] = 0;
			if (cMoreInfo==1)//give the senders ip address as well
				printf("%s (%s) \n", rgcBuf, WriteName(&sNetAddr));
			else
				printf("%s \n",rgcBuf);
		}
		if (kbhit())
		{
			key1 = getch();
			if (key1== 20){ //CTRL-T
				printf("<Input a string to broadcast> ");
				gets(rgcKeyBuf);
				iLength = sprintf(rgcBuf, "%s :%s", pMyName, rgcKeyBuf);
				//broadcast data
				if (WriteSocket(iSendSock, rgcBuf, iLength, NET_FLG_BROADCAST) < 0)//error
					printf("Error on NetWrite %d bytes: %s\n", iLength, Err(iNetErrNo));
			} else if (key1==24){ //CTRL-X
				ReleaseSocket(iRcvSock);
				ReleaseSocket(iSendSock);
				return;
			}
	  	}

	}
}

/*
Get a socket descriptor that can be used to send UDP packets

Returns: A descriptor of the socket, or 0 if an error occured. (Returns 
immediately) */ 
static int GetClientSock(void) { int iSock;
	memset(&sNetAddr, 0, sizeof(NET_ADDR));
	sNetAddr.wRemotePort = CHAT_PORT;

	if ((iSock = GetSocket()) < 0)
		printf("Error on GetSocket(): %s\n",Err(iNetErrNo));
	else if (SetSocketOption(iSock, 0, NET_OPT_NON_BLOCKING, 1, 1) < 0)
		printf("Error on setOpt(): %s\n",Err(iNetErrNo));
	else if (ConnectSocket(iSock, DATA_GRAM, &sNetAddr) < 0)
		printf("Error on net_connect: %s\n",Err(iNetErrNo));
	else
	{
		printf("Client sock successfully created\n");
		return iSock;
	}

	return 0;
}
/*
Start a UDP server on specified port.

Returns:
	A descriptor of the server socket, or 0 if an error occured.
	(Returns immediately)

*/
int StartListen(int iPort)
{
	int iServSock;	//the new socket

	memset(&sNetAddr, 0, sizeof(NET_ADDR));
	sNetAddr.wLocalPort = iPort;

	if ((iServSock = GetSocket()) < 0)
		printf("Error on serv GetSocket(): %s\n",Err(iNetErrNo));
	else if (SetSocketOption(iServSock, 0, NET_OPT_NON_BLOCKING, 1, 1) < 0)
		printf("Error on serv setOpt(): %s\n", Err(iNetErrNo));
	else if (ListenSocket(iServSock, DATA_GRAM, &sNetAddr) < 0)
		printf("Error on serv net_listen: %s\n", Err(iNetErrNo));
	else
	{
		printf("Server sock successfully created\n");
		return iServSock;
	}
	return 0;
}

/*
Creates a human understandible string from a Sockets error code

Argument:
	uErrCode - The sockets error code

Returns:
	A pointer to the (static) string representation of the error
*/
char *Err(unsigned uErrCode)
{
	static char rgcUnk[30];
	static char *rgszErrs[] =
	{
		"NoErr",
		"InUse",
		"DOSErr",
		"NoMem",
		"NotNetconn",
		"IllegalOp",
		"BadPkt",
		"NoHost",
		"CantOpen",
		"NetUnreachable",
		"HostUnreachable",
		"ProtUnreachable",
		"PortUnreachable",
		"TimeOut",
		"HostUnknown",
		"NoServers",
		"ServerErr",
		"BadFormat",
		"BadArg",
		"EOF",
		"Reset",
		"WouldBlock",
		"UnBound",
		"NoDesc",
		"BadSysCall",
		"CantBroadcast",
		"NotEstab",
		"ReEntry",
	};

	if (uErrCode == ERR_API_NOT_LOADED)
		return "Sockets API not loaded";
	if ((uErrCode & 0xff) > ERR_RE_ENTRY)
	{
		sprintf(rgcUnk,"Unknown error 0x%04X",uErrCode);
		return rgcUnk;
	}
	return rgszErrs[uErrCode & 0xff];
}


/*
Show data on screen.

For now we just use vprintf to print the data and reprint any stuff that was
being edited.

Later we may put each person's data in a seperate block on screen, or whatever
seems fancy.

Arguments:
	Format and eclipse - Exactly the same as for prinf().
*/
void Aprintf (char *pFormat, ...)
{
	printf(pFormat);
#if 0
	va_list pArgs;

	if (iKeyCount)//data been edited, start on newline
		printf("\n");

	va_start(pArgs, pFormat);
	vprintf(pFormat, pArgs);
	va_end(pArgs);

	//print the old edited stuff (if any)
	if (iKeyCount)
	{
		rgcKeyBuf[iKeyCount] = 0;
		printf("%s", rgcKeyBuf);
	}
#endif
}

/*
Create a string representation of the IP address and port, in the form
	a.b.c.d:port, eg 196.10.180.3:1400.
Max length is 22 bytes.

Arguments:
	psAddr - pointer to NET_ADDR structure containing address of host.

Returns:
	Pointer to (static) array containing null-terminated string.
*/
static char *WriteName(NET_ADDR *psAddr)
{
	static char rgcName[22];

	sprintf(rgcName, "%u.%u.%u.%u:%u",
		((BYTE *)&psAddr->dwRemoteHost)[0],
		((BYTE *)&psAddr->dwRemoteHost)[1],
		((BYTE *)&psAddr->dwRemoteHost)[2],
		((BYTE *)&psAddr->dwRemoteHost)[3],
		psAddr->wRemotePort
	);
	return rgcName;
}

